
public class Mandarino extends Frutto 
{
    int numeroFoglie;
    
    //costruttori
    public Mandarino(int numeroFoglie)
    {
        //si richiama il costruttore della superclasse
        super();
        this.numeroFoglie = numeroFoglie;
    }
    
    public Mandarino(int numeroFoglie, String colore)
    {        
        //si richiama il costruttore della superclasse con un parametro
        super(colore);
        this.numeroFoglie = numeroFoglie;
    }
    
    //metodi
    public String toString()
    {   
        //si richiama il metodo toString della superclasse poichè si usa super
        return super.toString() + "; numeroFoglie: " + numeroFoglie;
    }

    //confronta restituisce true o false se due mandarini sono uguali
    public boolean confronta(Mandarino m)
    {
        //si controllano il colore, ereditato dalla superclasse, e il numeroDiFoglie
        //per colore, super non è necessario poichè l'attributo viene ereditato dalla superclasse
        //e non c'è un altro attributo colore nella sottoclasse Mandarino
        if(m.colore.equals(this.colore) && m.numeroFoglie == this.numeroFoglie)
            return true;
        else
            return false;
    }
}